package gov.va.genisis2.service.impl;

import static org.junit.Assert.assertEquals;

import java.util.List;

import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.dao.impl.LookUpDaoTest;
import gov.va.genisis2.exceptions.GenisisServiceException;
import gov.va.genisis2.model.RequestType;
import gov.va.genisis2.model.Source;
import gov.va.genisis2.service.ILookUpService;

/**
 * The Class LookUpServiceTest.
 *
 * @author Prasad Thummalapalli
 * @author Getaneh Kassahun
 * 
 *          The Class LookUpServiceTest.
 * 
 *          Description: In this LookUpServiceTest Class which extends the
 *          abstract class, AbstractMockMvcTests, junit tests are defined.
 */

public class LookUpServiceTest extends AbstractMockMvcTests {

	/** The logger. */
	private final Logger logger = LoggerFactory.getLogger(LookUpDaoTest.class);

	@Autowired
	private ILookUpService lookUpService;

	/**
	 * Test get status id 0.
	 * 
	 * @throws GenisisServiceException
	 */
	@Test
	public void testGetStatusId() throws GenisisServiceException {
		assertEquals(0, lookUpService.getStatusId("null"));
		assertEquals(1, lookUpService.getStatusId("Draft"));
		assertEquals(2, lookUpService.getStatusId("Submitted"));
		assertEquals(3, lookUpService.getStatusId("Denied"));
		assertEquals(4, lookUpService.getStatusId("Returned"));
		assertEquals(5, lookUpService.getStatusId("Sent"));
		assertEquals(6, lookUpService.getStatusId("Update"));
		assertEquals(7, lookUpService.getStatusId("RequestAccepted"));
		assertEquals(8, lookUpService.getStatusId("RequestNotAccepted"));
		assertEquals(9, lookUpService.getStatusId("ResultsAccepted"));
		assertEquals(10, lookUpService.getStatusId("ResultsNotAccepted"));
	}

	/**
	 * Test get RequestType.
	 * 
	 * @throws GenisisServiceException
	 */
	@Test
	public void testGetRequestType() throws GenisisServiceException {

		logger.info("**********Junit Test get RequestType**********");
		RequestType requestType = lookUpService.getRequestType(1);
		assertEquals("Aggregate", requestType.getDescription());

	}

	/**
	 * Test get GetSource.
	 * 
	 * @throws GenisisServiceException
	 */
	@Test
	public void testGetSource() throws GenisisServiceException {

		logger.info("**********Junit Test get Source**********");
		Source sourceType = lookUpService.getSource(1);
		assertEquals("Survey", sourceType.getDescription());

	}

	/**
	 * Test get DataSources.
	 * 
	 * @throws GenisisServiceException
	 */
	@Test
	public void testgetDataSources() throws GenisisServiceException {

		logger.info("**********Junit Test get DataSources**********");
		List<Source> sourceList = lookUpService.getDataSources();
		assertEquals("Survey", sourceList.get(0).getDescription());

	}

	/**
	 * Test get RequestTypes.
	 * 
	 * @throws GenisisServiceException
	 */
	@Test
	public void testGetRequestTypes() throws GenisisServiceException {

		logger.info("**********Junit Test get RequestTypes**********");
		List<RequestType> requestTypeList = lookUpService.getRequestTypes();
		assertEquals("Aggregate", requestTypeList.get(0).getDescription());

	}
}